//  POV-Ray 3.0 Librerator data file written by John Perkins



#ifndef (Liberator_Drive_Ambient)
        #declare Liberator_Drive_Ambient = 0.8;
#end

#ifndef (Liberator_Firing)
        #declare Liberator_Firing = 0;
#end


#declare Ship_Grey =
	color rgb <0.9, 0.9, 0.9> ;

#declare Transparent =
	colour rgbf <0, 0, 0, 1> ;

#declare Ship_Texture =
	texture {
		pigment { Ship_Grey }
		finish  { reflection 0.1 ambient 0.2 diffuse 0.8 roughness 0.1  phong 8 }
 //       normal  { bumps -0.5 scale <1, 0.001, 0.001> }
	}

#default {
	texture {Ship_Texture}
}

// ================
// Panel for Turret
// ================
#declare panel_1 = 
difference {
	union {
		box { <0.0, 0.0, 0.0>, <15.0, 6.0, 0.3>
		}
		box { <3.5, 1.5, -0.5>, <11.5, 4.5, 0.0>
			pigment { color red 0.6 green 0.6 blue 0.6}
		}
	}
	union {
		box { <4.0, 2.0, -0.6>, < 6.0, 4.0, 0.2>
		pigment { color red 0.5 green 0.5 blue 0.5}
		}
		box { <6.5, 2.0, -0.6>, < 8.5, 4.0, 0.2>
		pigment { color red 0.5 green 0.5 blue 0.5}
		}
		box { <9.0, 2.0, -0.6>, <11.0, 4.0, 0.2>
		pigment { color red 0.5 green 0.5 blue 0.5}
		}
	}
	translate <-7.5, -3.0, -9.55>
}

// ================
// Strut for Turret
// ================
#declare strut_1 =
union {
	box { <-20.0, 1.5, -0.1>, < -18.5, 2.0, 0.1> }
	difference {
		box { <-20.0, 2.0, -0.1>, < -14.0, 3.5, 0.1> }
		plane {< 1.5, -3.0, 0 >, 0 translate <-20, 2.0, 0>}
		bounded_by {box { <-20.0, 2.0, -0.1>, < -14.0, 3.5, 0.1> }}
	}
}

// ==================
// Antenna for Turret
// ==================
#declare antenna_1 =
union {
	cylinder {   0*x, -15*x, 0.3 }
	cone     { -15*x, 0.3, -30*x, 0.1 }
	sphere   { -25*x, 0.35 }
}

// ===========================
// Features for tail of turret
// ===========================
#declare feature_box =
    box { <0.0, 0.0, -0.4>, <1.4, 0.05, 0.4>
		pigment { color red 0.6 green 0.6 blue 0.6}
	}

#declare feature_1 =
union {
	union {
		cylinder { <0.4, 0.0, 0.0>, 
		           <5.9, 0.0, 0.0>, 0.4
		}
		sphere { <0.4, 0.0, 0.0>, 0.4
		}
		sphere { <5.9, 0.0, 0.0>, 0.4
		}
		scale <1.0, 1.33, 1.0>
		translate <0.0, 4.5, 0.0>
	}
	object {feature_box translate <4.8, 4.5 0.0> rotate <22.5, 0, 0> }
	object {feature_box translate <4.8, 4.5 0.0> rotate <45.0, 0, 0> }
	object {feature_box translate <4.8, 4.5 0.0> rotate <67.5, 0, 0> }
}

// =========================
// The main body of the ship
// =========================

#declare body_1 =
union {
	// Nose Cone
	// ---------
	object { antenna_1 translate -32*x } 
	sphere { -32.0*x, 2.0 }
	cone   { -32.0*x, 2.0, -27.0*x, 2.9 }

	// Fins for nose cone
	// ------------------
	#declare nose_bit_1 =
	difference {
		box   { <0.0, 0.0, -0.1 >, <7.0, 1.5, 0.1> }
		plane {<1, -2, 0>, 0}
		// bounded_by {box   { <0.0, 0.0, -0.1 >, <5.0, 0.8, 0.1> }}
		rotate    10*z
		translate <-32.0, 2.0, 0>
	}
	object { nose_bit_1 }
	object { nose_bit_1 rotate  90*x }
	object { nose_bit_1 rotate 180*x }
	object { nose_bit_1 rotate 270*x }

	cone   { -27.0*x, 3.0, -24.0*x, 3.2 }
	torus { 3.0, 0.2 rotate 90*z translate -24*x }
	cone { -24.0*x, 3.0, -12.0*x, 3.9
		pigment { color red 0.6 green 0.6 blue 0.6}
	}
	// Feature cone
	difference {
		cone { -24.0*x, 3.1, -12.0*x, 4.0
			clipped_by { plane { -1*x, 0 translate -22*x} }
		}
		union {
			box { <-22.0, -1.0, -4.1>, < -15.0, 1.0, 4.1>
			}
			box { <0.71, -0.71, -4.1>, < -0.71, 0.71, 4.1>
				rotate     45*z
				translate -15*x
			}
			cylinder { <-22.0, -0.5,  4.1>, 
					   <-22.0, -0.5, -4.1>, 1.8
			}
		}
	}
	torus { 3.7, 0.3 rotate 90*z translate -12*x }
	cylinder { -12.0*x, -8.0*x, 3.5 }

	// Main Body
	// ---------
	torus { 3.5, 0.5 rotate 90*z translate -8*x	}
	cylinder { -8.0*x, 16.0*x, 4.0 }

	// Red boxes
	// ---------
	#declare red_box =
	superellipsoid { <0.25, 0.25>
		pigment { color rgb <0.4, 0.1, 0.1> }
		scale <3.5, 0.7, 1.2>
		translate <-4.0, 3.9, -0.3>
	}
	object {red_box }
	object {red_box rotate  90*x }
	object {red_box rotate 180*x }
	object {red_box rotate 270*x }

	// Bits for intake
	// ---------------
	#declare body_bit_1 =
	difference {
		box { <0.0, 2.8, -0.15>, <10.0, 7.8, 0.15> }
		plane {<4.8, -6.2, 0.0 >, 0 translate <0 3 0>}
	}
	object { body_bit_1 rotate   0*x }
	object { body_bit_1 rotate  15*x }
	object { body_bit_1 rotate  30*x }
	object { body_bit_1 rotate  45*x }
	object { body_bit_1 rotate  60*x }
	object { body_bit_1 rotate  75*x }
	object { body_bit_1 rotate  90*x }
	object { body_bit_1 rotate 105*x }
	object { body_bit_1 rotate 120*x }
	object { body_bit_1 rotate 135*x }
	object { body_bit_1 rotate 150*x }
	object { body_bit_1 rotate 165*x }
	object { body_bit_1 rotate 180*x }
	object { body_bit_1 rotate 195*x }
	object { body_bit_1 rotate 210*x }
	object { body_bit_1 rotate 225*x }
	object { body_bit_1 rotate 240*x }
	object { body_bit_1 rotate 255*x }
	object { body_bit_1 rotate 270*x }
	object { body_bit_1 rotate 285*x }
	object { body_bit_1 rotate 300*x }
	object { body_bit_1 rotate 315*x }
	object { body_bit_1 rotate 330*x }
	object { body_bit_1 rotate 345*x }

	difference {
		cylinder {  6.0*x, 16.0*x, 8.0 }
		cylinder {  5.9*x, 15.8*x, 7.8 }
	}
	torus { 7.0, 1.0 rotate 90*z  translate 16*x }

	// Alien Writing on Hull
	// ---------------------
	#declare Writing_1 =
		texture {
			pigment {
				image_map { iff "writing1.iff" once filter 0, 1.0 }
		        translate <-0.5, -0.5, -0.5>
				scale <16.0 16.0 16.0>
				translate <12.0, 1.0, -8.3>
			} 
			finish { ambient 0.2 diffuse 0.8 }
		}
	// Feature cylinder
	// ----------------
	difference {
		union {
			cylinder { 6.0*x, 15.6*x, 8.2 }
			torus    { 8.0, 0.2 rotate 90*z translate 15.6*x }
		}
		union {
			cylinder { 5.9*x, 15.8*x, 7.8 }
			box      { <10.0, -8.3, -8.3>, <16.0, -2.0, 8.3> }
		}
		texture {
			pigment { color red 0.7 green 0.7 blue 0.7}
			finish { ambient 0.2 diffuse 0.8 } 
		}
		texture { Writing_1 }
		texture { Writing_1 rotate 180*y}
	}

	// Box for feature cylinder
	// ------------------------
	#declare feature_box1 =
	    box { <0.0, 0.0, -0.3>, <1.2, 0.3, 0.3>
			pigment { color rgb <0.7, 0.7, 0.7> }
			translate <6.5, 8.2, 0.0>
		}
	object { feature_box1 rotate   0*x }
	object { feature_box1 rotate  36*x }
	object { feature_box1 rotate  72*x }
	object { feature_box1 rotate 108*x }
	object { feature_box1 rotate 144*x }
	object { feature_box1 rotate 180*x }
	object { feature_box1 rotate 216*x }
	object { feature_box1 rotate 252*x }
	object { feature_box1 rotate 288*x }
	object { feature_box1 rotate 324*x }

	// Brown bit
	// ---------
	// Brown_box for main hull
	// -----------------------

	#declare grey_stripes =
		texture {
			pigment {
				gradient x
				color_map {
					[ 0.0 color Ship_Grey ]
					[ 0.1 color Ship_Grey ]
					[ 0.1 color Transparent ]
					[ 1.0 color Transparent ]
				}
			}
			scale <3.77, 3.77, 3.77>
		}

	#declare brown_box = 
		box { <16.0, 7.0, -1.88>, <28.0, 7.2, 1.88>
			texture {
				pigment { color rgb <0.61 0.53 0.35>}
				finish { ambient 0.2 diffuse 0.5 }
			}
			texture { grey_stripes }
			texture { grey_stripes rotate 90*y }
	}
	object { brown_box rotate   0*x }
	object { brown_box rotate  30*x }
	object { brown_box rotate  60*x }
	object { brown_box rotate  90*x }
	object { brown_box rotate 120*x }
	object { brown_box rotate 150*x }
	object { brown_box rotate 180*x }
	object { brown_box rotate 210*x }
	object { brown_box rotate 240*x }
	object { brown_box rotate 270*x }
	object { brown_box rotate 300*x }
	object { brown_box rotate 330*x }

	// Tail Section
	// ------------
	cylinder { 28*x, 46*x, 7.2 }
	#declare tail_feature =
    union {
		union {
			cylinder { <0.5, -0.2, -0.5>, <0.5, 0.3, -0.5>, 0.5
				pigment { color rgb <0.7, 0.7, 0.7> }
			} 
			cylinder { <1.5, -0.2, -0.5>, <1.5, 0.3, -0.5>, 0.5
				pigment { color rgb <0.7, 0.7, 0.7> }
			} 
			box { <0, -0.2, 0>, <2, 0.3, 0.5>
				pigment { color rgb <0.7, 0.7, 0.7> }
			}
			translate <40, 7.2, 0.0>
			rotate -50*x
		}
	    box { <0.0, 0.0, -0.5>, <1.5, 0.3, 0.5>
			pigment { color rgb <0.7, 0.7, 0.7> }
			translate <32, 7.2, 0.0>
			rotate -55*x
		}
	    box { <0.0, 0.0, -0.4>, <1.4, 0.3, 0.4>
			pigment { color rgb <0.7, 0.7, 0.7> }
			translate <38, 7.2, 0.0>
			rotate -85*x
		}
	    box { <0.0, 0.0, -0.4>, <1.4, 0.3, 0.4>
			pigment { color rgb <0.7, 0.7, 0.7> }
			translate <30, 7.2, 0.0>
			rotate -100*x
		}
		union {
			cylinder { <0.4, 0.0, 0.0>, 
			           <5.9, 0.0, 0.0>, 0.4
			}
			sphere { <0.4, 0.0, 0.0>, 0.4
			}
			sphere { <5.9, 0.0, 0.0>, 0.4
			}
			scale <2.0, 1.33, 1.0>
			translate <30, 7.2, 0.0>
			rotate -70*x
		}
	}
	object { tail_feature }
	object { tail_feature rotate 120*x }
	object { tail_feature rotate 240*x }
	cone     { 46*x, 7.2, 51*x, 9.2 } 
	sphere   { <0, 0, 0>, 12.0
		texture { pigment { color rgb <0.04, 0.54, 0.04> }
		          finish { ambient Liberator_Drive_Ambient diffuse 0.2 }
		}
		texture { grey_stripes rotate 90*y scale 0.3}
		texture {
			pigment {
				image_map { iff "Tail-Bit.iff" map_type 1 filter 0, 1.0 }
				rotate 180*y
			} 
			finish { ambient 0.2 diffuse 0.8 }
		}
		translate 58*x
	}

	lathe {
		linear_spline
		3,
		<11.8, -1>, <13, 0>, <11.8, 1>
		translate 58*x
	}

	// Strut Arm
	// ---------
	#declare strut_box =
		box { <-4, -2, -4>, <4, 0, 0>
				rotate -35*x
		}

	#declare strut_end =
		union {
			object { strut_box }
			object { strut_box rotate 180*y } 
		}

	#declare Strut =
		union {
			box { <-1.0, 0.0, -1.0>, <1.0, 28.0, 1.0>
				rotate 45*y
				rotate 17.5*z
				scale <2.5, 1.0, 1.0>
				translate <41.5, 7.0, 0.0>
			}
			object { strut_end translate <40, 9.2, 0> }
			box { <0, 0, -0.3>, <8.0, 2.0, 0.3>
				rotate 15*z
				translate <29, 5.0, 0>
			}
			box { <-0.2, -1, -1>, <0.2, 1, 1> rotate 45*x translate <35, 7.5, 0> }
			box { <-0.2, -1, -1>, <0.2, 1, 1> rotate 45*x translate <34, 7.2, 0> }
			box { <-0.2, -1, -1>, <0.2, 1, 1> rotate 45*x translate <33, 6.9, 0> }
			box { <-0.2, -1, -1>, <0.2, 1, 1> rotate 45*x translate <32, 6.6, 0> }
			object { strut_end rotate 180*z translate <25, 27, 0> }
			box { <0, 0, -0.3>, <4.0, 2.0, 0.3>
				rotate -25*z
				translate <18, 29.0, 0>
			}
			box { <-0.2, -1, -1>, <0.2, 1, 1> rotate 45*x translate <20, 29, 0> }
			box { <-0.2, -1, -1>, <0.2, 1, 1> rotate 45*x translate <19, 29.5, 0> }
		}
	object { Strut }
	object { Strut rotate 120*x }
	object { Strut rotate 240*x }
}

// ============
// The Libeator
// ============

#declare liberator = 
union {
	object { body_1 }
	#declare turret = 1 ;

	#while (turret <= 3)

		// ==========
		// The turret
		// ==========
		#declare turret_1 = 
		union {
			// Main Body
			// ---------
			object { panel_1 rotate <  0 0 0> }
			object { panel_1 rotate < 36 0 0> }
			object { panel_1 rotate < 72 0 0> }
			object { panel_1 rotate <108 0 0> }
			object { panel_1 rotate <144 0 0> }
			object { panel_1 rotate <180 0 0> }
			object { panel_1 rotate <216 0 0> }
			object { panel_1 rotate <252 0 0> }
			object { panel_1 rotate <288 0 0> }
			object { panel_1 rotate <324 0 0> }

			// Nose Cone
			// ---------
			cone { < -7.5, 0.0, 0.0>, 9.4
			       <-14.0, 0.0, 0.0>, 3.0
			}
			cone { <-14.0, 0.0, 0.0>, 3.0
				   <-17.0, 0.0, 0.0>, 1.5
			}
			cylinder { <-17.0, 0.0, 0.0>, 
			           <-20.0, 0.0, 0.0>, 1.5
			}
			sphere { <-20.0, 0.0, 0.0>, 1.5
			}
			// Struts on Nose Cone
			object { strut_1 rotate <  0 0 0> }
			object { strut_1 rotate < 36 0 0> }
			object { strut_1 rotate < 72 0 0> }
			object { strut_1 rotate <108 0 0> }
			object { strut_1 rotate <144 0 0> }
			object { strut_1 rotate <180 0 0> }
			object { strut_1 rotate <216 0 0> }
			object { strut_1 rotate <252 0 0> }
			object { strut_1 rotate <288 0 0> }
			object { strut_1 rotate <324 0 0> }

			// Antenna array
			object { antenna_1 translate <-20.0, 0.0, 0.0> }
			object { antenna_1 scale <0.6, 0.6, 0.6> translate <-20.0,  1.0, 0.0> }
			object { antenna_1 scale <0.6, 0.6, 0.6> translate <-20.0, -1.0, 0.0> }
			object { antenna_1 scale <0.6, 0.6, 0.6> translate <-20.0, 0.0,  1.0> }
			object { antenna_1 scale <0.6, 0.6, 0.6> translate <-20.0, 0.0, -1.0> }

			// Tail Section
			// ------------
			cylinder { < 7.0, 0.0, 0.0>,
		               < 7.5, 0.0, 0.0> 9.5
			}
			cone { < 7.5, 0.0, 0.0>, 8.5
			       <16.0, 0.0, 0.0>, 5.0
			}
			cylinder { <16.0, 0.0, 0.0>, 
			           <18.0, 0.0, 0.0>, 5.0
			}
			torus { 5.0, 1.0
				rotate <0, 0, 90>
				translate <18, 0, 0>
			}
			// Alien Writing on turret
			// -----------------------
			#declare Writing =
				texture {
					pigment {
						image_map { iff "writing.iff" once filter 0, 1.0 }
			    	    translate <-0.5, -0.5, -0.5>
						scale 12.0
						translate <21.0, 0.0, -6.0>
					} 
					finish { ambient 0.2 diffuse 0.8 }
				}
			cylinder { <18.0, 0.0, 0.0>, 
			           <29.0, 0.0, 0.0>, 6.0
				texture { pigment { Ship_Grey } }
    		    #if ((turret = 1) | (turret = 3))
					texture { Writing }
				#end
				#if ((turret = 1) | (turret = 2))
					texture { Writing rotate 180*y }
				#end
			}
			torus { 5.0, 1.0
				rotate <0, 0, 90>
				translate <29, 0, 0>
			}
			cylinder { <29.0, 0.0, 0.0>, 
			           <37.0, 0.0, 0.0>, 4.5
			}
			object { feature_1 translate <29.5 0.0 0.0> }
			object { feature_1 translate <29.5 0.0 0.0> rotate < 90 0 0> }
			object { feature_1 translate <29.5 0.0 0.0> rotate <180 0 0> }
			object { feature_1 translate <29.5 0.0 0.0> rotate <270 0 0> }
			cone { <37.0, 0.0, 0.0>, 4.5
			       <41.0, 0.0, 0.0>, 3.0
			}
		}
	#switch (turret)
		#case (1) object { turret_1 translate 35*y } #break
       	#case (2) object { turret_1 rotate -120*x translate 35*y rotate 120*x } #break
		#case (3) object { turret_1 rotate -240*x translate 35*y rotate 240*x } #break
	#end

	#declare turret = turret + 1 ;
	#end
}
